Ext.data.JsonP.sol_common_Instance({"tagname":"class","name":"sol.common.Instance","autodetected":{},"files":[{"filename":"lib_sol.common.Instance.js","href":"lib_sol.common.Instance.html#sol-common-Instance"},{"filename":"lib_sol.common.Library.js","href":"lib_sol.common.Library.html#sol-common-Instance"}],"extends":"sol.Base","singleton":true,"experimental":{"text":"<p>This is an experimental new functionality, which may be removed in future versions.</p>\n\n<p>This class provides basic functionality to create solution instances.</p>\n\n<p>It can be used to create single independent instances of the defined instanceDefinition\nand addresses misuses and / or misunderstandings regarding <a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a> and <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>.</p>\n\n<p>Contrary to <a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>, properties defined via sol.common.instance.define are not properties\ndefined as \"class properties\" which may be shared with other \"class instances\" of the same class\nor of classes which extend the class, but are properties defined as \"instance properties\" which,\nif not explicit set as \"class properties\", are only available and accessable within the same\n\"instance\".</p>\n\n<h1>Defining instances - basic syntax</h1>\n\n<p>Every instance is represented by an instance name that should include a namespace and the instance\ndefinition.\nThe instance definition is a js object that represents the contents of that instance. Functions and\nproperties that are part of the instanceDefinition will be part of the instance.</p>\n\n<pre><code>sol.common.instance.define(instanceName, intanceDefinition);\n</code></pre>\n\n<h2>initialize - Function</h2>\n\n<p>The initialize function will be called during the creation of an instance with the provided\nconfiguration.\nDue to the fact that all instances (except \"<a href=\"#!/api/sol.common.instance.logger\" rel=\"sol.common.instance.logger\" class=\"docClass\">sol.common.instance.logger</a>\") extend at least\n\"<a href=\"#!/api/sol.common.instance.base\" rel=\"sol.common.instance.base\" class=\"docClass\">sol.common.instance.base</a>\", every instance does have an initialize function.\n\"<a href=\"#!/api/sol.common.instance.base\" rel=\"sol.common.instance.base\" class=\"docClass\">sol.common.instance.base</a>\"'s initialize functions applies the properties of then configuration\nto the instance.</p>\n"},"eloall":true,"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"$definedInstances","tagname":"property","owner":"sol.common.Instance","id":"property-S-definedInstances","meta":{"private":true}},{"name":"$definedSingletons","tagname":"property","owner":"sol.common.Instance","id":"property-S-definedSingletons","meta":{"private":true}},{"name":"$globalParent","tagname":"property","owner":"sol.common.Instance","id":"property-S-globalParent","meta":{"private":true}},{"name":"baseInstances","tagname":"property","owner":"sol.common.Instance","id":"property-baseInstances","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$instanceSuper","tagname":"method","owner":"sol.common.Instance","id":"method-S-instanceSuper","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"callMethodsOnInstance","tagname":"method","owner":"sol.common.Instance","id":"method-callMethodsOnInstance","meta":{"private":true}},{"name":"clone","tagname":"method","owner":"sol.common.Instance","id":"method-clone","meta":{"private":true}},{"name":"create","tagname":"method","owner":"sol.common.Instance","id":"method-create","meta":{"private":true}},{"name":"createMixins","tagname":"method","owner":"sol.common.Instance","id":"method-createMixins","meta":{"private":true}},{"name":"createParent","tagname":"method","owner":"sol.common.Instance","id":"method-createParent","meta":{"private":true}},{"name":"define","tagname":"method","owner":"sol.common.Instance","id":"method-define","meta":{"private":true}},{"name":"getInstanceDefinition","tagname":"method","owner":"sol.common.Instance","id":"method-getInstanceDefinition","meta":{"private":true}},{"name":"getParentAttribute","tagname":"method","owner":"sol.common.Instance","id":"method-getParentAttribute","meta":{"private":true}},{"name":"getSingleton","tagname":"method","owner":"sol.common.Instance","id":"method-getSingleton","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"merge","tagname":"method","owner":"sol.common.Instance","id":"method-merge","meta":{"private":true}},{"name":"setInstanceDefinition","tagname":"method","owner":"sol.common.Instance","id":"method-setInstanceDefinition","meta":{"private":true}},{"name":"setSingleton","tagname":"method","owner":"sol.common.Instance","id":"method-setSingleton","meta":{"private":true}}],"alternateClassNames":[],"aliases":{},"id":"class-sol.common.Instance","private":null,"mixins":[],"requires":[],"uses":[],"classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.Instance</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.Instance.html#sol-common-Instance' target='_blank'>lib_sol.common.Instance.js</a></div><div class='dependency'><a href='source/lib_sol.common.Library.html#sol-common-Instance' target='_blank'>lib_sol.common.Library.js</a></div></pre><div class='doc-contents'><p>This class provides basic functionality to create javascript Instances.</p>\n        <div class='rounded-box experimental-box deprecated-tag-box'>\n        <p>This class is <strong>experimental</strong> </p>\n        <p>This is an experimental new functionality, which may be removed in future versions.</p>\n\n<p>This class provides basic functionality to create solution instances.</p>\n\n<p>It can be used to create single independent instances of the defined instanceDefinition\nand addresses misuses and / or misunderstandings regarding <a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a> and <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>.</p>\n\n<p>Contrary to <a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>, properties defined via sol.common.instance.define are not properties\ndefined as \"class properties\" which may be shared with other \"class instances\" of the same class\nor of classes which extend the class, but are properties defined as \"instance properties\" which,\nif not explicit set as \"class properties\", are only available and accessable within the same\n\"instance\".</p>\n\n<h1>Defining instances - basic syntax</h1>\n\n<p>Every instance is represented by an instance name that should include a namespace and the instance\ndefinition.\nThe instance definition is a js object that represents the contents of that instance. Functions and\nproperties that are part of the instanceDefinition will be part of the instance.</p>\n\n<pre><code>sol.common.instance.define(instanceName, intanceDefinition);\n</code></pre>\n\n<h2>initialize - Function</h2>\n\n<p>The initialize function will be called during the creation of an instance with the provided\nconfiguration.\nDue to the fact that all instances (except \"<a href=\"#!/api/sol.common.instance.logger\" rel=\"sol.common.instance.logger\" class=\"docClass\">sol.common.instance.logger</a>\") extend at least\n\"<a href=\"#!/api/sol.common.instance.base\" rel=\"sol.common.instance.base\" class=\"docClass\">sol.common.instance.base</a>\", every instance does have an initialize function.\n\"<a href=\"#!/api/sol.common.instance.base\" rel=\"sol.common.instance.base\" class=\"docClass\">sol.common.instance.base</a>\"'s initialize functions applies the properties of then configuration\nto the instance.</p>\n\n        </div>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-S-definedInstances' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Instance'>sol.common.Instance</span><br/><a href='source/lib_sol.common.Instance.html#sol-common-Instance-property-S-definedInstances' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Instance-property-S-definedInstances' class='name expandable'>$definedInstances</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-S-definedSingletons' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Instance'>sol.common.Instance</span><br/><a href='source/lib_sol.common.Instance.html#sol-common-Instance-property-S-definedSingletons' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Instance-property-S-definedSingletons' class='name expandable'>$definedSingletons</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-S-globalParent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Instance'>sol.common.Instance</span><br/><a href='source/lib_sol.common.Instance.html#sol-common-Instance-property-S-globalParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Instance-property-S-globalParent' class='name expandable'>$globalParent</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;sol.common.instance.base&quot;</code></p></div></div></div><div id='property-baseInstances' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Instance'>sol.common.Instance</span><br/><a href='source/lib_sol.common.Instance.html#sol-common-Instance-property-baseInstances' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Instance-property-baseInstances' class='name expandable'>baseInstances</a> : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>[&quot;sol.common.instance.base&quot;, &quot;sol.common.instance.logger&quot;]</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-instanceSuper' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Instance'>sol.common.Instance</span><br/><a href='source/lib_sol.common.Instance.html#sol-common-Instance-method-S-instanceSuper' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Instance-method-S-instanceSuper' class='name expandable'>$instanceSuper</a>( <span class='pre'>instance, name, attributeName, args</span> ) : *<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Finds attribute in parent instance. ...</div><div class='long'><p>Finds attribute in parent instance.\nIf found attribute is a function, attribute will be called in instance context and\nwith given args as arguments. Calls to $super within the attribute can only access\nitself and its own parents.\nif found attribute is not a function, a cloned version of attribute will be returned.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instance</span> : *<div class='sub-desc'><p>the current instance (gets bound as first parameter within create)</p>\n</div></li><li><span class='pre'>name</span> : String<div class='sub-desc'><p>name of the parent class (Optional)</p>\n</div></li><li><span class='pre'>attributeName</span> : String<div class='sub-desc'><p>name of the attribute (Mandatory)</p>\n</div></li><li><span class='pre'>args</span> : *<div class='sub-desc'><p>arguments to pass to function, if value at aParent[attributeName] is a function (optional)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>*</span><div class='sub-desc'><p>the result of a function call or the value at the given attribute</p>\n</div></li></ul></div></div></div><div id='method-S-super' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-callMethodsOnInstance' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Instance'>sol.common.Instance</span><br/><a href='source/lib_sol.common.Instance.html#sol-common-Instance-method-callMethodsOnInstance' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Instance-method-callMethodsOnInstance' class='name expandable'>callMethodsOnInstance</a>( <span class='pre'>instance, methods, args</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instance</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>methods</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-clone' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Instance'>sol.common.Instance</span><br/><a href='source/lib_sol.common.Instance.html#sol-common-Instance-method-clone' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Instance-method-clone' class='name expandable'>clone</a>( <span class='pre'>obj</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>obj</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-create' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Instance'>sol.common.Instance</span><br/><a href='source/lib_sol.common.Instance.html#sol-common-Instance-method-create' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Instance-method-create' class='name expandable'>create</a>( <span class='pre'>name, config, options</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-createMixins' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Instance'>sol.common.Instance</span><br/><a href='source/lib_sol.common.Instance.html#sol-common-Instance-method-createMixins' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Instance-method-createMixins' class='name expandable'>createMixins</a>( <span class='pre'>instanceDefinition, config, options</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instanceDefinition</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-createParent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Instance'>sol.common.Instance</span><br/><a href='source/lib_sol.common.Instance.html#sol-common-Instance-method-createParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Instance-method-createParent' class='name expandable'>createParent</a>( <span class='pre'>instanceDefinition, config, options</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instanceDefinition</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-define' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Instance'>sol.common.Instance</span><br/><a href='source/lib_sol.common.Instance.html#sol-common-Instance-method-define' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Instance-method-define' class='name expandable'>define</a>( <span class='pre'>name, instanceDefinition, config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>instanceDefinition</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getInstanceDefinition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Instance'>sol.common.Instance</span><br/><a href='source/lib_sol.common.Instance.html#sol-common-Instance-method-getInstanceDefinition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Instance-method-getInstanceDefinition' class='name expandable'>getInstanceDefinition</a>( <span class='pre'>name, _options</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>_options</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getParentAttribute' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Instance'>sol.common.Instance</span><br/><a href='source/lib_sol.common.Instance.html#sol-common-Instance-method-getParentAttribute' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Instance-method-getParentAttribute' class='name expandable'>getParentAttribute</a>( <span class='pre'>parent, name, attributeName</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>parent</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>attributeName</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getSingleton' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Instance'>sol.common.Instance</span><br/><a href='source/lib_sol.common.Instance.html#sol-common-Instance-method-getSingleton' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Instance-method-getSingleton' class='name expandable'>getSingleton</a>( <span class='pre'>name, _options</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>_options</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-merge' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Instance'>sol.common.Instance</span><br/><a href='source/lib_sol.common.Instance.html#sol-common-Instance-method-merge' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Instance-method-merge' class='name expandable'>merge</a>( <span class='pre'>sources, target</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sources</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>target</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-setInstanceDefinition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Instance'>sol.common.Instance</span><br/><a href='source/lib_sol.common.Instance.html#sol-common-Instance-method-setInstanceDefinition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Instance-method-setInstanceDefinition' class='name expandable'>setInstanceDefinition</a>( <span class='pre'>name, instanceDefinition</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>instanceDefinition</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-setSingleton' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Instance'>sol.common.Instance</span><br/><a href='source/lib_sol.common.Instance.html#sol-common-Instance-method-setSingleton' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Instance-method-setSingleton' class='name expandable'>setSingleton</a>( <span class='pre'>name, singletonDefinition</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>singletonDefinition</span> : Object<div class='sub-desc'></div></li></ul></div></div></div></div></div></div></div>","meta":{"eloall":true,"experimental":{"text":"<p>This is an experimental new functionality, which may be removed in future versions.</p>\n\n<p>This class provides basic functionality to create solution instances.</p>\n\n<p>It can be used to create single independent instances of the defined instanceDefinition\nand addresses misuses and / or misunderstandings regarding <a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a> and <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>.</p>\n\n<p>Contrary to <a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>, properties defined via sol.common.instance.define are not properties\ndefined as \"class properties\" which may be shared with other \"class instances\" of the same class\nor of classes which extend the class, but are properties defined as \"instance properties\" which,\nif not explicit set as \"class properties\", are only available and accessable within the same\n\"instance\".</p>\n\n<h1>Defining instances - basic syntax</h1>\n\n<p>Every instance is represented by an instance name that should include a namespace and the instance\ndefinition.\nThe instance definition is a js object that represents the contents of that instance. Functions and\nproperties that are part of the instanceDefinition will be part of the instance.</p>\n\n<pre><code>sol.common.instance.define(instanceName, intanceDefinition);\n</code></pre>\n\n<h2>initialize - Function</h2>\n\n<p>The initialize function will be called during the creation of an instance with the provided\nconfiguration.\nDue to the fact that all instances (except \"<a href=\"#!/api/sol.common.instance.logger\" rel=\"sol.common.instance.logger\" class=\"docClass\">sol.common.instance.logger</a>\") extend at least\n\"<a href=\"#!/api/sol.common.instance.base\" rel=\"sol.common.instance.base\" class=\"docClass\">sol.common.instance.base</a>\", every instance does have an initialize function.\n\"<a href=\"#!/api/sol.common.instance.base\" rel=\"sol.common.instance.base\" class=\"docClass\">sol.common.instance.base</a>\"'s initialize functions applies the properties of then configuration\nto the instance.</p>\n"},"singleton":true}});